﻿<# This form was created using POSHGUI.com  a free online gui designer for PowerShell
.NAME
    Byte Splitter

Code by Kamencesc // DigichafarFan // Bonus
#>

Add-Type -AssemblyName System.Windows.Forms
[System.Windows.Forms.Application]::EnableVisualStyles()

$Form                            = New-Object system.Windows.Forms.Form
$Form.ClientSize                 = '406,210'
$Form.text                       = "Byte Splitter (Powershell Ed. By Kamencesc)"
$Form.TopMost                    = $false

$Label1                          = New-Object system.Windows.Forms.Label
$Label1.text                     = "Path:"
$Label1.AutoSize                 = $true
$Label1.width                    = 25
$Label1.height                   = 10
$Label1.location                 = New-Object System.Drawing.Point(14,30)
$Label1.Font                     = 'Microsoft Sans Serif,10'

$sourcePath                      = New-Object system.Windows.Forms.TextBox
$sourcePath.multiline            = $false
$sourcePath.width                = 280
$sourcePath.height               = 20
$sourcePath.location             = New-Object System.Drawing.Point(51,27)
$sourcePath.Font                 = 'Microsoft Sans Serif,10'

$Button1                         = New-Object system.Windows.Forms.Button
$Button1.text                    = "..."
$Button1.width                   = 33
$Button1.height                  = 30
$Button1.location                = New-Object System.Drawing.Point(340,21)
$Button1.Font                    = 'Microsoft Sans Serif,10'

$Groupbox1                       = New-Object system.Windows.Forms.Groupbox
$Groupbox1.height                = 64
$Groupbox1.width                 = 380
$Groupbox1.text                  = "Source file"
$Groupbox1.location              = New-Object System.Drawing.Point(11,12)

$Groupbox2                       = New-Object system.Windows.Forms.Groupbox
$Groupbox2.height                = 64
$Groupbox2.width                 = 380
$Groupbox2.text                  = "Destination files (will be saved in .lo and .hi ext)"
$Groupbox2.location              = New-Object System.Drawing.Point(11,89)

$Label2                          = New-Object system.Windows.Forms.Label
$Label2.text                     = "Path:"
$Label2.AutoSize                 = $true
$Label2.width                    = 25
$Label2.height                   = 10
$Label2.location                 = New-Object System.Drawing.Point(14,30)
$Label2.Font                     = 'Microsoft Sans Serif,10'

$Button2                         = New-Object system.Windows.Forms.Button
$Button2.text                    = "..."
$Button2.width                   = 33
$Button2.height                  = 30
$Button2.location                = New-Object System.Drawing.Point(340,21)
$Button2.Font                    = 'Microsoft Sans Serif,10'

$destinationPath                 = New-Object system.Windows.Forms.TextBox
$destinationPath.multiline       = $false
$destinationPath.width           = 280
$destinationPath.height          = 20
$destinationPath.location        = New-Object System.Drawing.Point(51,27)
$destinationPath.Font            = 'Microsoft Sans Serif,10'

$Button3                         = New-Object system.Windows.Forms.Button
$Button3.text                    = "Go"
$Button3.width                   = 60
$Button3.height                  = 30
$Button3.location                = New-Object System.Drawing.Point(331,165)
$Button3.Font                    = 'Microsoft Sans Serif,10'

$ProgressBar1                    = New-Object system.Windows.Forms.ProgressBar
$ProgressBar1.width              = 300
$ProgressBar1.height             = 30
$ProgressBar1.value              = 0
$ProgressBar1.location           = New-Object System.Drawing.Point(11,165)

$Groupbox1.controls.AddRange(@($Label1,$sourcePath,$Button1))
$Form.controls.AddRange(@($Groupbox1,$Groupbox2,$Button3,$ProgressBar1))
$Groupbox2.controls.AddRange(@($Label2,$Button2,$destinationPath))

$Button1.Add_Click({ getsource })
$Button2.Add_Click({ getdest })
$Button3.Add_Click({ doSomething })

#Write your logic code here

Function getsource() {
    $sourcePath.Text = Get-FileName -initialDirectory “c:fso”
}

Function getdest() {
    $destinationPath.Text = Set-FileName -initialDirectory “c:fso”
}

Function Get-FileName($initialDirectory)
{   
    [System.Reflection.Assembly]::LoadWithPartialName(“System.windows.forms”) |
 Out-Null
    $OpenFileDialog = New-Object System.Windows.Forms.OpenFileDialog
    $OpenFileDialog.initialDirectory = $initialDirectory
    $OpenFileDialog.filter = “All files (*.*)| *.*”
    $OpenFileDialog.ShowDialog() | Out-Null
    $OpenFileDialog.filename
} #end function Get-FileName

Function Set-FileName($initialDirectory)
{   
    [System.Reflection.Assembly]::LoadWithPartialName(“System.windows.forms”) |
 Out-Null
    $OpenFileDialog = New-Object System.Windows.Forms.SaveFileDialog
    $OpenFileDialog.initialDirectory = $initialDirectory
    $OpenFileDialog.filter = “All files (*.*)| *.*”
    $OpenFileDialog.ShowDialog() | Out-Null
    $OpenFileDialog.filename
} #end function Get-FileName

Function doSomething() {
    $ProgressBar1.value = 0
    # Read the entire file to an array of bytes.
    $bytes = [System.IO.File]::ReadAllBytes($sourcePath.text)
    $size = $bytes.count
    $lo_bytes = @(0) * ( $size/2 )
    $hi_bytes = @(0) * ( $size/2 )
    for ($i=0; $i -le $size-1; $i=$i+2) {
        $lo_bytes[$i/2] = $bytes[$i]
        $hi_bytes[$i/2] = $bytes[$i+1]
        $ProgressBar1.value = ( $i / $size ) * 100
    }
    [System.IO.File]::WriteAllBytes($destinationPath.text + '.lo', $lo_bytes)
    [System.IO.File]::WriteAllBytes($destinationPath.text + '.hi', $hi_bytes)
    [System.Windows.MessageBox]::Show('Done')
}

[void]$Form.ShowDialog()

